#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.Common.UnitTests
{

	
	

	[TestFixture]
	public class Common_VbecsConfig : BaseTest 
	{
		[Test]
		public void Ctor_Pass()
		{
			Assert.IsNotNull( new VbecsConfig() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}
		

		[Test]
		public void PrimaryDbConnectionString_Pass()
		{
			Assert.IsTrue( VbecsConfig.Current.PrimaryDbConnectionString.Length > 0 );
		}

				
		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void PrimaryDbConnectionString_Fail()
		{
		}

		[Test]
		public void VistACacheRefreshInterval_Pass()
		{
			int tstValue = Common.VbecsConfig.Current.VistACacheRefreshInterval;

			Assert.AreEqual(Common.VbecsConfig.Current.VistACacheRefreshInterval, tstValue);
		}

				
		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void VistACacheRefreshInterval_Fail()
		{
		}

		[Test]
		public void DateFormat_Pass()
		{
			Assert.IsTrue( VbecsConfig.Current.DateFormat.Length > 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void DateFormat_Fail()
		{
		}

		[Test]
		public void DateTimeFormat_Pass()
		{
			Assert.IsTrue( VbecsConfig.Current.DateTimeFormat.Length > 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void DateTimeFormat_Fail()
		{
		}

		[Test]
		public void LongDateTimeFormat_Pass()
		{
			Assert.IsTrue( VbecsConfig.Current.LongDateTimeFormat.Length > 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LongDateTimeFormat_Fail()
		{
		}

		[Test]
		public void TimeFormat_Pass()
		{
			Assert.IsTrue( VbecsConfig.Current.TimeFormat.Length > 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void TimeFormat_Fail()
		{
		}

		[Test]
		public void LongTimeFormat_Pass()
		{
			Assert.IsTrue( VbecsConfig.Current.LongTimeFormat.Length > 0 );
		}	
	
		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LongTimeFormat_Fail()
		{
		}

		[Test]
		public void Current_Pass()
		{
			Assert.IsNotNull( VbecsConfig.Current );
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Current_Fail()
		{
		}

		[Test]
		public void ErrorLogFileName_Pass()
		{
			Assert.IsTrue(VbecsConfig.Current.ErrorLogFileName.Length > 0, "ErrorLogFileName does not exist." );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ErrorLogFileName_Fail()
		{
		}

		[Test]
		public void VbecsUserDomainGroupName_Pass()
		{
			Assert.IsTrue( VbecsConfig.Current.VbecsUserDomainGroupName.Length > 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void VbecsUserDomainGroupName_Fail()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void VbecsAdminDomainGroupName_Fail()
		{
		}

		[Test]
		public void VbecsAdminDomainGroupName_Pass()
		{
			Assert.IsTrue( VbecsConfig.Current.VbecsAdminDomainGroupName.Length > 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void DbQueryTimeoutSeconds_Fail()
		{
		}

		[Test]
		public void  DbQueryTimeoutSeconds_Pass()
		{
			Assert.IsTrue( VbecsConfig.Current.DbQueryTimeoutSeconds > 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void EnvironmentType_Fail()
		{
		}

		[Test]
		public void  EnvironmentType_Pass()
		{
			Assert.IsTrue( VbecsConfig.Current.EnvironmentType.Length > 0 );
		}

		
		[Test]
		public void  ErrorProviderSpeakDelayInMilliseconds_Pass()
		{
			Assert.IsTrue( VbecsConfig.Current.ErrorProviderSpeakDelayInMilliseconds > 0 );
		}
		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void  ErrorProviderSpeakDelayInMilliseconds_Fail()
		{
		}
		}
}
#endif
